<?php
header("Access-Control-Allow-Origin: *");
header("Content-Type: application/json");
require_once 'db.php';

$response = ['status' => 'error', 'message' => '', 'data' => []];

try {
    // Query to get all active blogs
    $sql = "SELECT 
                blog_id,
                Blog_Title AS title,
                Category AS category,
                date AS pastdate,
                start_time AS starttime,
                end_time AS endtime,
                location,
                description,
                Blog_image AS images
            FROM blogs 
            WHERE active = 1";
    
    $result = $conn->query($sql);
    
    if ($result) {
        $blogs = [];
        while ($row = $result->fetch_assoc()) {
            // Decode the JSON image paths if they exist
            if (!empty($row['images'])) {
                $row['images'] = json_decode($row['images'], true);
            } else {
                $row['images'] = [];
            }
            $blogs[] = $row;
        }
        
        $response = [
            'status' => 'success',
            'message' => 'Blogs retrieved successfully',
            'data' => $blogs,
            'count' => count($blogs)
        ];
    } else {
        throw new Exception("Database error: " . $conn->error);
    }
} catch (Exception $e) {
    $response['message'] = $e->getMessage();
} finally {
    $conn->close();
    echo json_encode($response);
}
?>